#ifndef __DISPLAY_H__
#define __DISPLAY_H__


#define STORE_ON  PORTB|=(1<<2)
#define STORE_OFF PORTB&=~(1<<2)

#define SCK_ON  PORTB|=(1<<5)
#define SCK_OFF PORTB&=~(1<<5)

#define MOSI_ON  PORTB|=(1<<3)
#define MOSI_OFF PORTB&=~(1<<3)

//adatok trolhelye; a bitszm a sor(Y) fordtva, a sorszm az oszlop(X); a leg-ALS bit nem jtszik.
volatile byte MX[30] =
	{
		0b11111100,
		0b00100010,
		0b00100010,
		0b11111100,
		0b00000000,
		0b11111110,
		0b10010010,
		0b10010010,
		0b01101100,
		0b00000000,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	};


void putpixel(byte X, byte Y, byte C)
{
	if(C) MX[X] |= 1<<(7-Y);
	else  MX[X] &= ~(1<<(7-Y));
}

void cls()
{
	for(byte x=0; x<30; x++) MX[x] = 0;
}




void WriteChar(uint8_t X, char ch)
{
	for(uint8_t i=0; i<5; i++) MX[X+i] =  pgm_read_byte(&(FONT[0][ch+(i/5)][i%5]));
}










#endif
